<?php
/* --------------------------------------------------------------
   WithdrawalServiceProvider.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal;

use Doctrine\DBAL\Connection;
use Gambio\Admin\Withdrawal\Interfaces\WithdrawalService;
use Gambio\Admin\Withdrawal\Repository\WithdrawalMapper;
use Gambio\Admin\Withdrawal\Repository\WithdrawalReader;
use Gambio\Admin\Withdrawal\Repository\WithdrawalRepository;
use Gambio\Admin\Withdrawal\Repository\WithdrawalWriter;
use Gambio\Admin\Withdrawal\WithdrawalService as WithdrawalServiceImpl;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Psr\EventDispatcher\EventDispatcherInterface;

/**
 * Class WithdrawalServiceProvider
 *
 * @package Gambio\Admin\Withdrawal
 * @codeCoverageIgnore
 */
class WithdrawalServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            WithdrawalService::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(WithdrawalFactory::class);
        $this->application->share(WithdrawalMapper::class)->addArgument(WithdrawalFactory::class);
        $this->application->share(WithdrawalReader::class)->addArgument(Connection::class);
        $this->application->share(WithdrawalWriter::class)->addArgument(Connection::class);
        
        $this->application->share(WithdrawalRepository::class)
            ->addArgument(WithdrawalMapper::class)
            ->addArgument(WithdrawalReader::class)
            ->addArgument(WithdrawalWriter::class)
            ->addArgument(EventDispatcherInterface::class);
        
        $this->application->share(WithdrawalService::class, WithdrawalServiceImpl::class)
            ->addArgument(WithdrawalRepository::class);
    }
}